<?php
/**
 * OXO.GE Admin — menu registration, settings, asset loading
 *
 * @package OxoGE
 * @since   3.0.0
 */

if (!defined('ABSPATH')) exit;

/* ─── Enqueue admin CSS ─── */
add_action('admin_enqueue_scripts', function ($hook) {
    if (strpos($hook, 'oxo-ge') === false && $hook !== 'index.php') return;
    wp_enqueue_style(
        'oxo-ge-admin',
        OXO_GE_PLUGIN_URL . 'assets/css/admin.css',
        [],
        OXO_GE_VERSION
    );
});

/* ─── Enqueue frontend shortcode CSS ─── */
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style(
        'oxo-ge-shortcodes',
        OXO_GE_PLUGIN_URL . 'assets/css/shortcodes.css',
        [],
        OXO_GE_VERSION
    );
});

/* ─── Register menu pages ─── */
add_action('admin_menu', function () {
    add_menu_page(
        'OXO.GE', 'OXO.GE', 'manage_options',
        'oxo-ge', 'oxo_ge_stats_page',
        'dashicons-chart-area', 30
    );
    add_submenu_page('oxo-ge', 'სტატისტიკა', '📊 სტატისტიკა',  'manage_options', 'oxo-ge',             'oxo_ge_stats_page');
    add_submenu_page('oxo-ge', 'შორტკოდები',  '🧩 შორტკოდები',  'manage_options', 'oxo-ge-shortcodes', 'oxo_ge_shortcodes_page');
    add_submenu_page('oxo-ge', 'სიახლეები',   '📰 სიახლეები',   'edit_posts',     'oxo-ge-news',       'oxo_ge_news_page');
    add_submenu_page('oxo-ge', 'პარამეტრები',  '⚙️ პარამეტრები', 'manage_options', 'oxo-ge-settings',   'oxo_ge_settings_page');
});

/* ─── Register settings ─── */
add_action('admin_init', function () {
    register_setting('oxo_ge_settings', 'oxo_ge_api_key');
    register_setting('oxo_ge_settings', 'oxo_ge_site_id');
    register_setting('oxo_ge_settings', 'oxo_ge_auto_publish');
    register_setting('oxo_ge_settings', 'oxo_ge_cache_ttl');
});
