<?php
/**
 * OXO.GE Admin — News submission page
 *
 * @package OxoGE
 * @since   2.0.0
 */

if (!defined('ABSPATH')) exit;

function oxo_ge_news_page() {
    $api_key = get_option('oxo_ge_api_key', '');
    $site_id = get_option('oxo_ge_site_id', '');
    $message = '';
    $error   = '';

    if (empty($api_key) || empty($site_id)) {
        echo '<div class="wrap oxo-wrap">';
        oxo_ge_page_header('სიახლეები', 'OXO.GE სიახლეების გამოქვეყნება', 'oxo-ge-news');
        echo '<div class="notice notice-warning"><p>ჯერ API გასაღები და საიტის ID დააკონფიგურირეთ: '
           . '<a href="' . admin_url('admin.php?page=oxo-ge-settings') . '">პარამეტრები →</a></p></div></div>';
        return;
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST'
        && isset($_POST['oxo_news_submit'])
        && wp_verify_nonce($_POST['_wpnonce'], 'oxo_ge_news_submit')
    ) {
        $title   = sanitize_text_field($_POST['news_title'] ?? '');
        $content = sanitize_textarea_field($_POST['news_content'] ?? '');
        $image   = esc_url_raw($_POST['news_image'] ?? '');

        if (empty($title) || empty($content)) {
            $error = 'სათაური და შინაარსი სავალდებულოა';
        } else {
            $result = oxo_ge_api_post_news($title, $content, $image);
            if (isset($result['success']) && $result['success']) {
                $message = 'სიახლე წარმატებით გაიგზავნა მოდერაციაზე! (ID: ' . ($result['news_id'] ?? '') . ')';
            } else {
                $error = $result['error'] ?? 'გაგზავნა ვერ მოხერხდა';
            }
        }
    }
    ?>
    <div class="wrap oxo-wrap">
        <?php oxo_ge_page_header('სიახლეები', 'გამოაქვეყნეთ სიახლეები OXO.GE-ზე', 'oxo-ge-news'); ?>

        <?php if ($message): ?>
            <div class="notice notice-success"><p>✅ <?php echo esc_html($message); ?></p></div>
        <?php endif; ?>
        <?php if ($error): ?>
            <div class="notice notice-error"><p>❌ <?php echo esc_html($error); ?></p></div>
        <?php endif; ?>

        <div class="oxo-news-form">
            <form method="post">
                <?php wp_nonce_field('oxo_ge_news_submit'); ?>
                <input type="hidden" name="oxo_news_submit" value="1" />
                <table class="form-table">
                    <tr>
                        <th><label for="news_title">📝 სათაური *</label></th>
                        <td><input type="text" id="news_title" name="news_title" class="large-text" maxlength="500" required placeholder="სიახლის სათაური" /></td>
                    </tr>
                    <tr>
                        <th><label for="news_content">📄 შინაარსი *</label></th>
                        <td><textarea id="news_content" name="news_content" class="large-text" rows="8" maxlength="5000" required placeholder="სიახლის ტექსტი (მაქს. 5000 სიმბოლო)"></textarea></td>
                    </tr>
                    <tr>
                        <th><label for="news_image">🖼️ სურათის URL</label></th>
                        <td>
                            <input type="url" id="news_image" name="news_image" class="large-text" placeholder="https://example.com/image.jpg" />
                            <p class="description">არასავალდებულო. სიახლის სათაური სურათი.</p>
                        </td>
                    </tr>
                </table>
                <p style="margin-top:8px;">
                    <button type="submit" class="oxo-btn oxo-btn-primary">
                        <span class="dashicons dashicons-share" style="font-size:16px;line-height:1.4;"></span> გაგზავნა OXO.GE-ზე
                    </button>
                </p>
            </form>
        </div>

        <div class="oxo-info-box">
            <h3>ℹ️ ინფორმაცია</h3>
            <ul>
                <li>სიახლეები გადის მოდერაციას OXO.GE-ს ადმინის მიერ</li>
                <li>მაქსიმუმ <strong>5</strong> სიახლის გაგზავნა შეიძლება დღეში</li>
                <li>სათაური: მაქსიმუმ 500 სიმბოლო</li>
                <li>შინაარსი: მაქსიმუმ 5000 სიმბოლო</li>
                <li>ავტო-პუბლიკაცია ჩართეთ <a href="<?php echo admin_url('admin.php?page=oxo-ge-settings'); ?>">პარამეტრებში</a></li>
            </ul>
        </div>

        <?php oxo_ge_footer(); ?>
    </div>
    <?php
}
