<?php
/**
 * OXO.GE Admin — Settings page
 *
 * @package OxoGE
 * @since   2.0.0
 */

if (!defined('ABSPATH')) exit;

function oxo_ge_settings_page() {
    if (isset($_GET['settings-updated'])) {
        oxo_ge_flush_cache();
        echo '<div class="notice notice-success is-dismissible"><p>✅ პარამეტრები შენახულია!</p></div>';
    }
    ?>
    <div class="wrap oxo-wrap">
        <?php oxo_ge_page_header('პარამეტრები', 'OXO.GE API კონფიგურაცია', 'oxo-ge-settings'); ?>

        <div class="oxo-settings-panel">
            <form method="post" action="options.php">
                <?php settings_fields('oxo_ge_settings'); ?>
                <table class="form-table">
                    <tr>
                        <th><label for="oxo_ge_api_key">🔑 API გასაღები</label></th>
                        <td>
                            <input type="text" id="oxo_ge_api_key" name="oxo_ge_api_key"
                                   value="<?php echo esc_attr(get_option('oxo_ge_api_key')); ?>"
                                   class="regular-text" placeholder="თქვენი OXO.GE API key" autocomplete="off" />
                            <p class="description">იპოვეთ: <a href="https://oxo.ge/dashboard?tab=api" target="_blank">oxo.ge/dashboard → API</a></p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="oxo_ge_site_id">🆔 საიტის ID</label></th>
                        <td>
                            <input type="number" id="oxo_ge_site_id" name="oxo_ge_site_id"
                                   value="<?php echo esc_attr(get_option('oxo_ge_site_id')); ?>"
                                   class="small-text" placeholder="123" />
                            <p class="description">საიტის ID OXO.GE სისტემაში</p>
                        </td>
                    </tr>
                    <tr>
                        <th>📤 ავტო-პუბლიკაცია</th>
                        <td>
                            <div class="oxo-toggle-wrap">
                                <label class="oxo-toggle">
                                    <input type="checkbox" name="oxo_ge_auto_publish" value="1"
                                           <?php checked(get_option('oxo_ge_auto_publish'), 1); ?> />
                                    <span class="oxo-toggle-slider"></span>
                                </label>
                                <span style="font-size:13px;color:var(--oxo-gray-600);">ახალი პოსტები ავტომატურად გაიგზავნოს OXO.GE-ზე</span>
                            </div>
                            <p class="description" style="margin-top:8px;">WordPress-ზე ახალი პოსტის გამოქვეყნებისას ის ავტომატურად გაიგზავნება OXO.GE-ს სიახლეებში.</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="oxo_ge_cache_ttl">⏱️ ქეშის ხანგრძლივობა</label></th>
                        <td>
                            <input type="number" id="oxo_ge_cache_ttl" name="oxo_ge_cache_ttl"
                                   value="<?php echo esc_attr(get_option('oxo_ge_cache_ttl', OXO_GE_CACHE_TTL)); ?>"
                                   class="small-text" min="60" max="3600" step="60" />
                            <span style="font-size:13px;color:var(--oxo-gray-500);"> წამი (60–3600)</span>
                            <p class="description">შორტკოდების მონაცემები ქეშდება ამ დროით. ბარგია: 300 წამი (5 წუთი).</p>
                        </td>
                    </tr>
                </table>
                <?php submit_button('💾 შენახვა', 'primary large'); ?>
            </form>
        </div>

        <?php if (get_option('oxo_ge_api_key')): ?>
            <?php
            $test = oxo_ge_api_get('summary');
            $ok   = isset($test['success']) && $test['success'];
            ?>
            <div class="oxo-connection-test <?php echo $ok ? 'success' : 'error'; ?>" style="max-width:640px;">
                <span class="status-icon"><?php echo $ok ? '✓' : '✗'; ?></span>
                <?php if ($ok): ?>
                    <strong>კავშირი წარმატებულია!</strong>
                    &mdash; საიტი: <strong><?php echo esc_html($test['site']['name']); ?></strong>
                    (ID: <?php echo (int)$test['site']['id']; ?>, რანკი: #<?php echo (int)$test['site']['rank']; ?>)
                <?php else: ?>
                    <strong>კავშირი ვერ მოხერხდა:</strong>
                    <?php echo esc_html($test['error'] ?? 'უცნობი შეცდომა'); ?>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php oxo_ge_footer(); ?>
    </div>
    <?php
}
