<?php
/**
 * OXO.GE Admin — Shortcodes reference & preview page
 *
 * @package OxoGE
 * @since   3.0.0
 */

if (!defined('ABSPATH')) exit;

function oxo_ge_shortcodes_page() {
    $registry = oxo_ge_shortcode_registry();

    // Handle cache flush
    if (isset($_POST['oxo_flush_cache']) && wp_verify_nonce($_POST['_wpnonce'], 'oxo_ge_flush_cache')) {
        oxo_ge_flush_cache();
        echo '<div class="notice notice-success is-dismissible"><p>✅ ქეში გასუფთავებულია!</p></div>';
    }

    $data     = oxo_ge_get_cached_summary();
    $has_data = isset($data['success']) && $data['success'];
    ?>
    <div class="wrap oxo-wrap">
        <?php oxo_ge_page_header('შორტკოდები', 'ჩასვით სტატისტიკა ნებისმიერ გვერდზე', 'oxo-ge-shortcodes'); ?>

        <!-- Intro -->
        <div class="oxo-shortcodes-intro">
            <div class="oxo-shortcodes-intro-icon">🧩</div>
            <div>
                <h3>რა არის შორტკოდები?</h3>
                <p>შორტკოდებით შეგიძლიათ OXO.GE-ს სტატისტიკა ჩასვათ ნებისმიერ გვერდზე, პოსტში, ვიჯეტში ან თემის ფაილში.
                   უბრალოდ დააკოპირეთ შორტკოდი და ჩასვით WordPress ედიტორში. დიზაინის მორგება შეგიძლიათ CSS-ით ან <code>style</code> ატრიბუტით.</p>
            </div>
        </div>

        <!-- Individual Shortcodes -->
        <div class="oxo-section">
            <div class="oxo-section-header">
                <h2>📌 ძირითადი შორტკოდები</h2>
                <span class="oxo-section-badge"><?php echo count($registry); ?> შორტკოდი</span>
            </div>

            <div class="oxo-shortcode-grid">
                <?php foreach ($registry as $tag => $meta):
                    $current_val = '—';
                    if ($has_data) {
                        $current_val = oxo_ge_resolve_stat($data, $meta) ?? '—';
                    }
                ?>
                    <div class="oxo-shortcode-item">
                        <div class="oxo-sc-header">
                            <span class="oxo-sc-icon"><?php echo $meta['icon']; ?></span>
                            <span class="oxo-sc-label"><?php echo esc_html($meta['label']); ?></span>
                            <?php if ($has_data): ?>
                                <span class="oxo-sc-live"><?php echo $current_val; ?></span>
                            <?php endif; ?>
                        </div>
                        <div class="oxo-sc-desc"><?php echo esc_html($meta['desc']); ?></div>
                        <div class="oxo-sc-code-row">
                            <code class="oxo-sc-code" id="sc-<?php echo esc_attr($tag); ?>">[<?php echo esc_html($tag); ?>]</code>
                            <button class="oxo-sc-copy" onclick="oxoCopy('sc-<?php echo esc_attr($tag); ?>', this)" title="კოპირება">📋</button>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Compound Shortcodes -->
        <div class="oxo-section">
            <div class="oxo-section-header">
                <h2>🎨 კომბინირებული შორტკოდები</h2>
                <span class="oxo-section-badge">ვიჯეტები</span>
            </div>

            <div class="oxo-compound-list">
                <div class="oxo-compound-item">
                    <div class="oxo-compound-header">
                        <span class="oxo-compound-name">📦 სტატისტიკის ბოქსი</span>
                        <span class="oxo-compound-tag">[oxo-stats-box]</span>
                    </div>
                    <p class="oxo-compound-desc">სრული სტატისტიკის ვიჯეტი — 6 ბარათი ჰედერით და ფუტერით. იდეალურია სადბარისთვის ან გვერდებისთვის.</p>
                    <div class="oxo-sc-code-row">
                        <code class="oxo-sc-code" id="sc-box-default">[oxo-stats-box]</code>
                        <button class="oxo-sc-copy" onclick="oxoCopy('sc-box-default', this)">📋</button>
                    </div>
                    <div class="oxo-sc-code-row" style="margin-top:6px;">
                        <code class="oxo-sc-code oxo-sc-code-sm" id="sc-box-custom">[oxo-stats-box title="ჩემი სტატისტიკა" stats="oxo-hits,oxo-unique,oxo-online,oxo-rank"]</code>
                        <button class="oxo-sc-copy" onclick="oxoCopy('sc-box-custom', this)">📋</button>
                    </div>
                </div>

                <div class="oxo-compound-item">
                    <div class="oxo-compound-header">
                        <span class="oxo-compound-name">🃏 ერთეული ბარათი</span>
                        <span class="oxo-compound-tag">[oxo-stats-card]</span>
                    </div>
                    <p class="oxo-compound-desc">ერთი სტატისტიკის ბარათი იკონით, რიცხვით და ლეიბლით.</p>
                    <div class="oxo-sc-code-row">
                        <code class="oxo-sc-code" id="sc-card-online">[oxo-stats-card stat="oxo-online"]</code>
                        <button class="oxo-sc-copy" onclick="oxoCopy('sc-card-online', this)">📋</button>
                    </div>
                    <div class="oxo-sc-code-row" style="margin-top:6px;">
                        <code class="oxo-sc-code" id="sc-card-rank">[oxo-stats-card stat="oxo-rank"]</code>
                        <button class="oxo-sc-copy" onclick="oxoCopy('sc-card-rank', this)">📋</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Attributes Reference -->
        <div class="oxo-section">
            <div class="oxo-section-header">
                <h2>🎯 პარამეტრები და კასტომიზაცია</h2>
                <span class="oxo-section-badge">ატრიბუტები</span>
            </div>
            <table class="oxo-table">
                <thead><tr><th>ატრიბუტი</th><th>აღწერა</th><th>მაგალითი</th></tr></thead>
                <tbody>
                    <tr><td><code>class</code></td><td>დამატებითი CSS კლასი</td><td><code>[oxo-online class="my-counter"]</code></td></tr>
                    <tr><td><code>style</code></td><td>ინლაინ CSS სტილი</td><td><code>[oxo-hits style="color:red;font-size:24px;"]</code></td></tr>
                    <tr><td><code>icon</code></td><td>აიკონის ჩვენება (<code>true</code> ან საკუთარი)</td><td><code>[oxo-online icon="true"]</code></td></tr>
                    <tr><td><code>label</code></td><td>ლეიბლის ჩვენება (<code>true</code> ან საკუთარი ტექსტი)</td><td><code>[oxo-hits label="ვიზიტი"]</code></td></tr>
                    <tr><td><code>prefix</code></td><td>ტექსტი რიცხვამდე</td><td><code>[oxo-rank prefix="პოზიცია: "]</code></td></tr>
                    <tr><td><code>suffix</code></td><td>ტექსტი რიცხვის შემდეგ</td><td><code>[oxo-hits suffix=" ვიზიტი"]</code></td></tr>
                    <tr><td><code>default</code></td><td>ნაგულისხმევი მნიშვნელობა (API-ს შეცდომისას)</td><td><code>[oxo-online default="N/A"]</code></td></tr>
                </tbody>
            </table>
        </div>

        <!-- CSS Reference -->
        <div class="oxo-section">
            <div class="oxo-section-header">
                <h2>🖌️ CSS კლასები</h2>
                <span class="oxo-section-badge">სტილიზაცია</span>
            </div>
            <div class="oxo-css-guide">
                <p>ყველა შორტკოდი იყენებს ქვემოთ ჩამოთვლილ CSS კლასებს. დაამატეთ სტილები თქვენს თემაში ან Customizer → Additional CSS-ში:</p>
                <div class="oxo-css-block">
                    <div class="oxo-css-block-header">
                        <span>CSS — მაგალითი</span>
                        <button class="oxo-sc-copy" onclick="oxoCopy('css-example', this)">📋</button>
                    </div>
                    <pre class="oxo-css-code" id="css-example">/* საერთო სტილი ყველა შორტკოდისთვის */
.oxo-stat { font-weight: 700; color: #6366f1; }

/* კონკრეტული სტატისტიკა */
.oxo-stat-online .oxo-stat-value { color: #10b981; font-size: 20px; }
.oxo-stat-rank .oxo-stat-value   { color: #f59e0b; }

/* ბოქსის ვიჯეტის მორგება */
.oxo-box-widget { max-width: 400px; border-radius: 16px; }

/* ბარათის მორგება */
.oxo-card-widget {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: #fff;
}</pre>
                </div>

                <table class="oxo-table" style="margin-top:16px;">
                    <thead><tr><th>კლასი</th><th>ელემენტი</th></tr></thead>
                    <tbody>
                        <tr><td><code>.oxo-stat</code></td><td>ძირითადი wrapper ყველა შორტკოდისთვის</td></tr>
                        <tr><td><code>.oxo-stat-value</code></td><td>რიცხვი/მნიშვნელობა</td></tr>
                        <tr><td><code>.oxo-stat-icon</code></td><td>აიკონი (icon ატრიბუტით)</td></tr>
                        <tr><td><code>.oxo-stat-label</code></td><td>ლეიბლი (label ატრიბუტით)</td></tr>
                        <tr><td><code>.oxo-stat-hits</code></td><td>ჰიტების კონკრეტული კლასი</td></tr>
                        <tr><td><code>.oxo-stat-online</code></td><td>ონლაინის კონკრეტული კლასი</td></tr>
                        <tr><td><code>.oxo-stat-rank</code></td><td>რანკის კონკრეტული კლასი</td></tr>
                        <tr><td><code>.oxo-box-widget</code></td><td>სრული სტატისტიკის ბოქსი</td></tr>
                        <tr><td><code>.oxo-card-widget</code></td><td>ერთეული ბარათი</td></tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Live Preview -->
        <?php if ($has_data): ?>
        <div class="oxo-section">
            <div class="oxo-section-header">
                <h2>👁️ პრევიუ</h2>
                <span class="oxo-section-badge">ლაივ</span>
            </div>
            <div class="oxo-preview-area">
                <h4>ინლაინ შორტკოდები:</h4>
                <p class="oxo-preview-inline">
                    საიტზე ამჟამად <strong><?php echo do_shortcode('[oxo-online icon="true"]'); ?></strong> ვიზიტორია ონლაინ.
                    დღეს <?php echo do_shortcode('[oxo-hits icon="true"]'); ?> ჰიტი მივიღეთ, აქედან
                    <?php echo do_shortcode('[oxo-unique]'); ?> უნიკალური.
                    რანკი: <?php echo do_shortcode('[oxo-rank style="color:#f59e0b;font-weight:800;"]'); ?>
                </p>

                <h4 style="margin-top:24px;">სტატისტიკის ბოქსი:</h4>
                <div class="oxo-preview-box-wrap">
                    <?php echo do_shortcode('[oxo-stats-box]'); ?>
                </div>

                <h4 style="margin-top:24px;">ერთეული ბარათები:</h4>
                <div class="oxo-preview-cards-wrap">
                    <?php echo do_shortcode('[oxo-stats-card stat="oxo-online"]'); ?>
                    <?php echo do_shortcode('[oxo-stats-card stat="oxo-rank"]'); ?>
                    <?php echo do_shortcode('[oxo-stats-card stat="oxo-georgia"]'); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Cache Control -->
        <div class="oxo-section" style="max-width:480px;">
            <div class="oxo-section-header">
                <h2>🔄 ქეშის მართვა</h2>
            </div>
            <p style="font-size:13px;color:var(--oxo-gray-500);margin-bottom:16px;">
                შორტკოდების მონაცემები ქეშდება <?php echo (int)get_option('oxo_ge_cache_ttl', OXO_GE_CACHE_TTL); ?> წამით.
                ქეშის ხანგრძლივობა შეცვალეთ <a href="<?php echo admin_url('admin.php?page=oxo-ge-settings'); ?>">პარამეტრებში</a>.
            </p>
            <form method="post">
                <?php wp_nonce_field('oxo_ge_flush_cache'); ?>
                <button type="submit" name="oxo_flush_cache" value="1" class="oxo-btn oxo-btn-secondary">
                    🔄 ქეშის გასუფთავება
                </button>
            </form>
        </div>

        <?php oxo_ge_footer(); ?>
    </div>

    <script>
    function oxoCopy(id, btn) {
        var el = document.getElementById(id);
        var text = el.textContent || el.innerText;
        navigator.clipboard.writeText(text).then(function() {
            btn.textContent = '✅';
            setTimeout(function() { btn.textContent = '📋'; }, 1500);
        });
    }
    </script>
    <?php
}
