<?php
/**
 * OXO.GE Admin — Statistics page
 *
 * @package OxoGE
 * @since   2.0.0
 */

if (!defined('ABSPATH')) exit;

function oxo_ge_stats_page() {
    $api_key = get_option('oxo_ge_api_key', '');
    if (empty($api_key)) {
        echo '<div class="wrap oxo-wrap">';
        oxo_ge_page_header('OXO.GE', 'სტატისტიკა', 'oxo-ge');
        echo '<div class="notice notice-warning"><p>ჯერ API გასაღები დააკონფიგურირეთ: '
           . '<a href="' . admin_url('admin.php?page=oxo-ge-settings') . '">პარამეტრები →</a></p></div></div>';
        return;
    }

    $summary   = oxo_ge_api_get('summary');
    $daily     = oxo_ge_api_get('daily', ['days' => 30]);
    $hourly    = oxo_ge_api_get('hourly');
    $geo       = oxo_ge_api_get('geo', ['days' => 7]);
    $browsers  = oxo_ge_api_get('browsers', ['days' => 7]);
    $devices   = oxo_ge_api_get('devices', ['days' => 7]);
    $referrers = oxo_ge_api_get('referrers', ['days' => 7]);
    $pages     = oxo_ge_api_get('pages', ['days' => 7]);
    ?>
    <div class="wrap oxo-wrap">
        <?php oxo_ge_page_header('სტატისტიკა', 'რეალ-ტაიმ ანალიტიკა OXO.GE-დან', 'oxo-ge'); ?>

        <?php /* ── Summary Cards ── */ ?>
        <?php if (isset($summary['success']) && $summary['success']): ?>
            <div class="oxo-cards">
                <div class="oxo-card oxo-card-accent">
                    <div class="oxo-card-icon">📈</div>
                    <div class="oxo-card-value"><?php echo oxo_ge_nf($summary['today']['hits']); ?></div>
                    <div class="oxo-card-label">ჰიტები დღეს</div>
                </div>
                <div class="oxo-card oxo-card-green">
                    <div class="oxo-card-icon">👤</div>
                    <div class="oxo-card-value"><?php echo oxo_ge_nf($summary['today']['unique_visitors']); ?></div>
                    <div class="oxo-card-label">უნიკალური</div>
                </div>
                <div class="oxo-card">
                    <div class="oxo-card-icon">🟢</div>
                    <div class="oxo-card-value"><span class="oxo-online-dot"></span><?php echo (int)$summary['today']['online_now']; ?></div>
                    <div class="oxo-card-label">ონლაინ ახლა</div>
                </div>
                <div class="oxo-card oxo-card-orange">
                    <div class="oxo-card-icon">🏆</div>
                    <div class="oxo-card-value">#<?php echo (int)$summary['site']['rank']; ?></div>
                    <div class="oxo-card-label">რანკი</div>
                </div>
                <div class="oxo-card">
                    <div class="oxo-card-icon">🇬🇪</div>
                    <div class="oxo-card-value"><?php echo (int)$summary['today']['georgia_pct']; ?>%</div>
                    <div class="oxo-card-label">საქართველოდან</div>
                </div>
                <div class="oxo-card">
                    <div class="oxo-card-icon">📅</div>
                    <div class="oxo-card-value"><?php echo oxo_ge_nf($summary['averages']['monthly_uniques']); ?></div>
                    <div class="oxo-card-label">თვიური უნიკალ.</div>
                </div>
            </div>

            <div class="oxo-cards" style="grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));">
                <div class="oxo-card">
                    <div class="oxo-card-value" style="font-size:22px;"><?php echo oxo_ge_nf($summary['yesterday']['hits']); ?></div>
                    <div class="oxo-card-label">ჰიტები გუშინ</div>
                </div>
                <div class="oxo-card">
                    <div class="oxo-card-value" style="font-size:22px;"><?php echo oxo_ge_nf($summary['yesterday']['unique_visitors']); ?></div>
                    <div class="oxo-card-label">უნიკალური გუშინ</div>
                </div>
                <div class="oxo-card">
                    <div class="oxo-card-value" style="font-size:22px;"><?php echo oxo_ge_nf($summary['averages']['daily_visitors']); ?></div>
                    <div class="oxo-card-label">საშუალო დღიური</div>
                </div>
                <div class="oxo-card">
                    <div class="oxo-card-value" style="font-size:22px;"><?php echo (int)$summary['demographics']['male_pct']; ?>% / <?php echo (int)$summary['demographics']['female_pct']; ?>%</div>
                    <div class="oxo-card-label">♂ / ♀</div>
                </div>
            </div>
        <?php else: ?>
            <div class="notice notice-error"><p>სტატისტიკის ჩატვირთვა ვერ მოხერხდა: <?php echo esc_html($summary['error'] ?? ''); ?></p></div>
        <?php endif; ?>

        <?php /* ── 30 Day Chart ── */ ?>
        <?php if (isset($daily['success']) && $daily['success'] && !empty($daily['data'])): ?>
            <div class="oxo-section">
                <div class="oxo-section-header">
                    <h2>📊 ბოლო 30 დღის სტატისტიკა</h2>
                    <span class="oxo-section-badge">უნიკალური ვიზიტორები</span>
                </div>
                <div class="oxo-chart-container">
                    <div class="oxo-chart-bars">
                        <?php
                        $maxVal = max(1, max(array_column($daily['data'], 'uniques')));
                        foreach ($daily['data'] as $day):
                            $pct = ($day['uniques'] / $maxVal) * 100;
                        ?>
                            <div class="oxo-chart-bar" style="height:<?php echo max(2, $pct); ?>%">
                                <div class="oxo-tooltip"><?php echo esc_html($day['date']); ?><br><strong><?php echo number_format($day['uniques']); ?></strong> უნიკალური</div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="oxo-chart-labels">
                        <?php
                        $total = count($daily['data']);
                        $step  = max(1, (int)($total / 6));
                        foreach ($daily['data'] as $i => $d):
                            $show = ($i % $step === 0 || $i === $total - 1);
                        ?>
                            <span><?php echo $show ? date('d/m', strtotime($d['date'])) : ''; ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php /* ── Hourly Chart ── */ ?>
        <?php if (isset($hourly['success']) && $hourly['success'] && !empty($hourly['data'])): ?>
            <div class="oxo-section">
                <div class="oxo-section-header">
                    <h2>🕐 დღევანდელი საათობრივი</h2>
                    <span class="oxo-section-badge">24 საათი</span>
                </div>
                <div class="oxo-chart-container">
                    <div class="oxo-chart-bars">
                        <?php
                        $maxH = max(1, max(array_column($hourly['data'], 'uniques')));
                        foreach ($hourly['data'] as $h):
                            $pct = ($h['uniques'] / $maxH) * 100;
                        ?>
                            <div class="oxo-chart-bar" style="height:<?php echo max(2, $pct); ?>%; background:var(--oxo-green);">
                                <div class="oxo-tooltip"><?php echo esc_html($h['label']); ?><br><strong><?php echo $h['uniques']; ?></strong> უნიკალური</div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="oxo-chart-labels">
                        <?php foreach ($hourly['data'] as $i => $h): ?>
                            <span><?php echo ($i % 3 === 0) ? esc_html($h['label']) : ''; ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php /* ── Geo + Browsers ── */ ?>
        <div class="oxo-grid-2">
            <?php if (isset($geo['success']) && $geo['success'] && !empty($geo['data'])): ?>
                <div class="oxo-section">
                    <div class="oxo-section-header">
                        <h2>🌍 ქვეყნები</h2>
                        <span class="oxo-section-badge">7 დღე</span>
                    </div>
                    <table class="oxo-table">
                        <thead><tr><th>ქვეყანა</th><th>უნიკალური</th><th></th></tr></thead>
                        <tbody>
                        <?php $maxGeo = max(1, $geo['data'][0]['uniques'] ?? 1);
                        foreach (array_slice($geo['data'], 0, 10) as $g): ?>
                            <tr>
                                <td><strong><?php echo esc_html($g['country']); ?></strong></td>
                                <td><?php echo number_format($g['uniques']); ?></td>
                                <td><div class="oxo-bar-wrap"><div class="oxo-bar oxo-bar-purple" style="width:<?php echo ($g['uniques'] / $maxGeo) * 100; ?>%"></div></div></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

            <?php if (isset($browsers['success']) && $browsers['success'] && !empty($browsers['data'])): ?>
                <div class="oxo-section">
                    <div class="oxo-section-header">
                        <h2>🌐 ბრაუზერები</h2>
                        <span class="oxo-section-badge">7 დღე</span>
                    </div>
                    <table class="oxo-table">
                        <thead><tr><th>ბრაუზერი</th><th>უნიკალური</th><th></th></tr></thead>
                        <tbody>
                        <?php $maxBr = max(1, $browsers['data'][0]['uniques'] ?? 1);
                        foreach (array_slice($browsers['data'], 0, 8) as $b): ?>
                            <tr>
                                <td><?php echo esc_html($b['browser']); ?></td>
                                <td><?php echo number_format($b['uniques']); ?></td>
                                <td><div class="oxo-bar-wrap"><div class="oxo-bar oxo-bar-orange" style="width:<?php echo ($b['uniques'] / $maxBr) * 100; ?>%"></div></div></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>

        <?php /* ── Devices + Referrers ── */ ?>
        <div class="oxo-grid-2">
            <?php if (isset($devices['success']) && $devices['success'] && !empty($devices['data'])): ?>
                <div class="oxo-section">
                    <div class="oxo-section-header">
                        <h2>📱 მოწყობილობები</h2>
                        <span class="oxo-section-badge">7 დღე</span>
                    </div>
                    <table class="oxo-table">
                        <thead><tr><th>ტიპი</th><th>უნიკალური</th><th></th></tr></thead>
                        <tbody>
                        <?php $maxDev = max(1, $devices['data'][0]['uniques'] ?? 1);
                        $devIcons = ['desktop' => '🖥️', 'mobile' => '📱', 'tablet' => '📲'];
                        foreach ($devices['data'] as $d): ?>
                            <tr>
                                <td><?php echo ($devIcons[$d['device']] ?? '💻') . ' ' . esc_html(ucfirst($d['device'])); ?></td>
                                <td><?php echo number_format($d['uniques']); ?></td>
                                <td><div class="oxo-bar-wrap"><div class="oxo-bar oxo-bar-green" style="width:<?php echo ($d['uniques'] / $maxDev) * 100; ?>%"></div></div></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

            <?php if (isset($referrers['success']) && $referrers['success'] && !empty($referrers['data'])): ?>
                <div class="oxo-section">
                    <div class="oxo-section-header">
                        <h2>🔗 ტრაფიკის წყაროები</h2>
                        <span class="oxo-section-badge">7 დღე</span>
                    </div>
                    <table class="oxo-table">
                        <thead><tr><th>წყარო</th><th>უნიკალური</th><th></th></tr></thead>
                        <tbody>
                        <?php $maxRef = max(1, $referrers['data'][0]['uniques'] ?? 1);
                        foreach (array_slice($referrers['data'], 0, 10) as $r): ?>
                            <tr>
                                <td><?php echo esc_html($r['source']); ?></td>
                                <td><?php echo number_format($r['uniques']); ?></td>
                                <td><div class="oxo-bar-wrap"><div class="oxo-bar" style="width:<?php echo ($r['uniques'] / $maxRef) * 100; ?>%;background:var(--oxo-purple);"></div></div></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>

        <?php /* ── Top Pages ── */ ?>
        <?php if (isset($pages['success']) && $pages['success'] && !empty($pages['data'])): ?>
            <div class="oxo-section">
                <div class="oxo-section-header">
                    <h2>📄 ტოპ გვერდები</h2>
                    <span class="oxo-section-badge">7 დღე</span>
                </div>
                <table class="oxo-table">
                    <thead><tr><th>გვერდი</th><th>ჰიტები</th><th>უნიკალური</th></tr></thead>
                    <tbody>
                    <?php foreach (array_slice($pages['data'], 0, 15) as $p): ?>
                        <tr>
                            <td style="max-width:400px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;"><?php echo esc_html($p['page']); ?></td>
                            <td><?php echo number_format($p['hits']); ?></td>
                            <td><?php echo number_format($p['uniques']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>

        <?php oxo_ge_footer(); ?>
    </div>
    <?php
}
