<?php
/**
 * OXO.GE Admin — WordPress Dashboard widget
 *
 * @package OxoGE
 * @since   2.0.0
 */

if (!defined('ABSPATH')) exit;

add_action('wp_dashboard_setup', function () {
    if (get_option('oxo_ge_api_key')) {
        wp_add_dashboard_widget(
            'oxo_ge_dashboard',
            '📊 OXO.GE სტატისტიკა',
            'oxo_ge_dashboard_widget'
        );
    }
});

function oxo_ge_dashboard_widget() {
    $data = oxo_ge_api_get('summary');
    if (!isset($data['success']) || !$data['success']) {
        echo '<p style="color:#ef4444;">შეცდომა: '
           . esc_html($data['error'] ?? 'კავშირი ვერ მოხერხდა') . '</p>';
        return;
    }
    ?>
    <div class="oxo-dw-grid">
        <div class="oxo-dw-stat">
            <div class="oxo-dw-val" style="color:var(--oxo-primary,#6366f1);"><?php echo oxo_ge_nf($data['today']['hits']); ?></div>
            <div class="oxo-dw-lbl">ჰიტები</div>
        </div>
        <div class="oxo-dw-stat">
            <div class="oxo-dw-val" style="color:var(--oxo-green,#10b981);"><?php echo oxo_ge_nf($data['today']['unique_visitors']); ?></div>
            <div class="oxo-dw-lbl">უნიკალური</div>
        </div>
        <div class="oxo-dw-stat">
            <div class="oxo-dw-val"><?php echo (int)$data['today']['online_now']; ?></div>
            <div class="oxo-dw-lbl">ონლაინ</div>
        </div>
    </div>
    <div style="margin-top:14px;text-align:center;">
        <span style="display:inline-block;padding:4px 12px;background:#fef3c7;color:#92400e;border-radius:20px;font-weight:600;font-size:12px;">
            🏆 რანკი: #<?php echo (int)$data['site']['rank']; ?>
        </span>
        <span style="margin-left:6px;font-size:12px;display:inline-block;padding:4px 12px;background:#ecfdf5;color:#065f46;border-radius:20px;font-weight:600;">
            🇬🇪 <?php echo (int)$data['today']['georgia_pct']; ?>%
        </span>
    </div>
    <p style="text-align:center;margin:14px 0 4px;">
        <a href="<?php echo admin_url('admin.php?page=oxo-ge'); ?>"
           class="button button-primary"
           style="background:#6366f1;border-color:#4f46e5;">სრული სტატისტიკა →</a>
    </p>
    <?php
}
