<?php
/**
 * OXO.GE Auto-publish — send new WP posts to OXO.GE news
 *
 * @package OxoGE
 * @since   2.0.0
 */

if (!defined('ABSPATH')) exit;

add_action('transition_post_status', function ($new_status, $old_status, $post) {
    if ($new_status !== 'publish' || $old_status === 'publish') return;
    if ($post->post_type !== 'post') return;
    if (!get_option('oxo_ge_auto_publish')) return;
    if (get_post_meta($post->ID, '_oxo_ge_sent', true)) return;

    $title   = $post->post_title;
    $content = wp_trim_words(strip_tags($post->post_content), 200, '...');
    $image   = get_the_post_thumbnail_url($post->ID, 'large');
    $result  = oxo_ge_api_post_news($title, $content, $image ?: '');

    if (isset($result['success']) && $result['success']) {
        update_post_meta($post->ID, '_oxo_ge_sent', 1);
        update_post_meta($post->ID, '_oxo_ge_news_id', $result['news_id'] ?? '');
    }
}, 10, 3);
