<?php
/**
 * OXO.GE Cache layer — transient-based caching for shortcodes
 *
 * @package OxoGE
 * @since   3.0.0
 */

if (!defined('ABSPATH')) exit;

/**
 * Get cached summary data. Falls back to live API if cache is empty.
 *
 * @return array  Summary data from API (cached)
 */
function oxo_ge_get_cached_summary() {
    $cache_key = 'oxo_ge_summary_v3';
    $cached    = get_transient($cache_key);

    if ($cached !== false) {
        return $cached;
    }

    $data = oxo_ge_api_get('summary');

    if (isset($data['success']) && $data['success']) {
        $ttl = (int) get_option('oxo_ge_cache_ttl', OXO_GE_CACHE_TTL);
        if ($ttl < 60) $ttl = 60;
        set_transient($cache_key, $data, $ttl);
    }

    return $data;
}

/**
 * Flush the summary cache (called on settings save, manual flush).
 */
function oxo_ge_flush_cache() {
    delete_transient('oxo_ge_summary_v3');
}
