<?php
/**
 * OXO.GE Helpers — shared UI components and utility functions
 *
 * @package OxoGE
 * @since   3.0.0
 */

if (!defined('ABSPATH')) exit;

/**
 * Format number with thousands separator.
 */
function oxo_ge_nf($n) {
    return number_format((int) $n);
}

/**
 * Render the admin page header with OXO logo and navigation tabs.
 *
 * @param string $title       Page title
 * @param string $subtitle    Page subtitle
 * @param string $active_page Currently active menu slug
 */
function oxo_ge_page_header($title, $subtitle, $active_page) {
    $pages = [
        'oxo-ge'            => ['label' => '📊 სტატისტიკა', 'url' => admin_url('admin.php?page=oxo-ge')],
        'oxo-ge-shortcodes' => ['label' => '🧩 შორტკოდები',  'url' => admin_url('admin.php?page=oxo-ge-shortcodes')],
        'oxo-ge-news'       => ['label' => '📰 სიახლეები',   'url' => admin_url('admin.php?page=oxo-ge-news')],
        'oxo-ge-settings'   => ['label' => '⚙️ პარამეტრები',  'url' => admin_url('admin.php?page=oxo-ge-settings')],
    ];
    ?>
    <div class="oxo-page-header">
        <div class="oxo-logo">OXO</div>
        <h1><?php echo esc_html($title); ?><small><?php echo esc_html($subtitle); ?></small></h1>
    </div>
    <div class="oxo-nav">
        <?php foreach ($pages as $slug => $p): ?>
            <a href="<?php echo esc_url($p['url']); ?>"
               class="<?php echo $active_page === $slug ? 'active' : ''; ?>">
                <?php echo $p['label']; ?>
            </a>
        <?php endforeach; ?>
    </div>
    <?php
}

/**
 * Render the standard plugin footer line.
 */
function oxo_ge_footer() {
    ?>
    <div class="oxo-footer">
        Powered by <a href="https://oxo.ge" target="_blank">OXO.GE</a> &bull; Plugin v<?php echo OXO_GE_VERSION; ?>
    </div>
    <?php
}
