<?php
/**
 * Plugin Name: OXO.GE Integration
 * Plugin URI:  https://oxo.ge
 * Description: OXO.GE სტატისტიკა, შორთკოდები, სიახლეების API და მრიცხველის ინტეგრაცია WordPress-ისთვის.
 * Version:     3.0.0
 * Author:      OXO.GE
 * Author URI:  https://oxo.ge
 * Text Domain: oxo-ge
 * License:     GPL v2 or later
 * Requires at least: 6.0
 * Requires PHP: 7.4
 */

if (!defined('ABSPATH')) exit;

/* ── Constants ────────────────────────────────────────── */
define('OXO_GE_VERSION',    '3.0.0');
define('OXO_GE_API_BASE',   'https://oxo.ge/api');
define('OXO_GE_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('OXO_GE_PLUGIN_URL', plugin_dir_url(__FILE__));
define('OXO_GE_CACHE_TTL',  (int) get_option('oxo_ge_cache_ttl', 300));

/* ── Core includes ────────────────────────────────────── */
require_once OXO_GE_PLUGIN_DIR . 'includes/api.php';
require_once OXO_GE_PLUGIN_DIR . 'includes/cache.php';
require_once OXO_GE_PLUGIN_DIR . 'includes/helpers.php';
require_once OXO_GE_PLUGIN_DIR . 'includes/shortcodes.php';
require_once OXO_GE_PLUGIN_DIR . 'includes/auto-publish.php';
require_once OXO_GE_PLUGIN_DIR . 'includes/counter.php';

/* ── Admin includes ───────────────────────────────────── */
if (is_admin()) {
    require_once OXO_GE_PLUGIN_DIR . 'admin/menu.php';
    require_once OXO_GE_PLUGIN_DIR . 'admin/page-stats.php';
    require_once OXO_GE_PLUGIN_DIR . 'admin/page-shortcodes.php';
    require_once OXO_GE_PLUGIN_DIR . 'admin/page-news.php';
    require_once OXO_GE_PLUGIN_DIR . 'admin/page-settings.php';
    require_once OXO_GE_PLUGIN_DIR . 'admin/widget-dashboard.php';
}
